import java.awt.*;
import java.awt.event.*;
import java.util.*;
import java.text.*;
import javax.swing.*;
import javax.swing.event.*;

/**
  *
  * SQLite - Buecherausleihe
  * Version 1.5 vom 16.3.2018
  * vom Hau 
  */

public class AusleihAnwendung extends JFrame {
  // Anfang Attribute
  private JButton btStart = new JButton();  
  private Verwalter meinVerwalter;
  private JLabel jLabel2 = new JLabel();
  private JLabel jLabel3 = new JLabel();
  private JButton btBuchZeigen = new JButton();
  private JButton btLeserZeigen = new JButton();
 
  private JLabel jLabel1 = new JLabel();
  private JLabel jLabel4 = new JLabel();
  private JTextField tfDatum = new JTextField();
  private JButton btAusleihen = new JButton();
  private Anzeige meineAnzeige;
  private String aus;
  int heuteTag, heuteMonat, heuteJahr;
  int maxAusleihId;
  Calendar meinKalender;
  private JTextField tfExemplar = new JTextField();
  private JTextField tfLeser = new JTextField();
  // Ende Attribute  
  
  public AusleihAnwendung(String title) { 
    // Frame-Initialisierung
    super(title);
    setDefaultCloseOperation(WindowConstants.EXIT_ON_CLOSE); //alle Fenster zu
    setSize(500,400);
    setLocation(20, 10);
    setResizable(true);
    Container cp = getContentPane();
    cp.setLayout(null);
    // Anfang Komponenten
    
    btStart.setBounds(312, 8, 121, 33);
    btStart.setText("Start");
    btStart.setMargin(new Insets(2, 2, 2, 2));
    btStart.addActionListener(new ActionListener() { 
      public void actionPerformed(ActionEvent evt) { 
        btStart_ActionPerformed(evt);
      }
    });
    cp.add(btStart);
    jLabel2.setBounds(16, 8, 199, 25);
    jLabel2.setText("SQLite - Datenbank BIB.db ffnen");
    cp.add(jLabel2);
    jLabel3.setBounds(16, 64, 128, 33);
    jLabel3.setText("Buchnummer(1-3496)");
    cp.add(jLabel3);
    //
    btBuchZeigen.setBounds(312, 64, 121, 33);
    btBuchZeigen.setText("Buch anzeigen");
    btBuchZeigen.setMargin(new Insets(2, 2, 2, 2));
    btBuchZeigen.addActionListener(new ActionListener() { 
      public void actionPerformed(ActionEvent evt) { 
        btBuchZeigen_ActionPerformed(evt);
      }
    });
    cp.add(btBuchZeigen);
    btLeserZeigen.setBounds(312, 120, 121, 33);
    btLeserZeigen.setText("Leser anzeigen");
    btLeserZeigen.setMargin(new Insets(2, 2, 2, 2));
    btLeserZeigen.addActionListener(new ActionListener() { 
      public void actionPerformed(ActionEvent evt) { 
        btLeserZeigen_ActionPerformed(evt);
      }
    });
    cp.add(btLeserZeigen);
    jLabel1.setBounds(16, 120, 132, 33);
    jLabel1.setText("Lesernummer(1-1466)");
    cp.add(jLabel1);
    jLabel4.setBounds(16, 176, 85, 33);
    jLabel4.setText("Datum");
    cp.add(jLabel4);
    tfDatum.setBounds(160, 176, 137, 33);
    cp.add(tfDatum);
    btAusleihen.setBounds(312, 176, 121, 33);
    btAusleihen.setText("ausleihen");
    btAusleihen.setMargin(new Insets(2, 2, 2, 2));
    btAusleihen.addActionListener(new ActionListener() { 
      public void actionPerformed(ActionEvent evt) { 
        btAusleihen_ActionPerformed(evt);
      }
    });
    cp.add(btAusleihen);
    tfExemplar.setBounds(160, 64, 137, 33);
    cp.add(tfExemplar);
    tfLeser.setBounds(160, 120, 137, 33);
    cp.add(tfLeser);
    // Ende Komponenten
    meineAnzeige = new Anzeige("Kontrolle");
    meineAnzeige.setVisible (false);
    setVisible(true);
  } // end of public AusleihAnwendung
  
  // Anfang Methoden
  
  public void btStart_ActionPerformed(ActionEvent evt) {
    meinVerwalter = new Verwalter(meineAnzeige );
    meinVerwalter.oeffneDB("bib.db");
    maxAusleihId = meinVerwalter.maxAusleihe(); // hoechster Wert fuere ausleih id
    
    meinKalender = Calendar.getInstance();      // Datum heute
    
    heuteTag= meinKalender.get(Calendar.DATE);  // als String yyyymmdd00000
    heuteMonat=meinKalender.get(Calendar.MONTH)+1; 
    heuteJahr=meinKalender.get(Calendar.YEAR);    
    tfDatum.setText(datumAus(heuteTag, heuteMonat, heuteJahr, 0 )) ;
    
  } // end of btStart_ActionPerformed
  
  public void btBuchZeigen_ActionPerformed(ActionEvent evt) {
    
    meinVerwalter.zeigeAbfrageMehrzeilig("Buch", "select band.titel, band.verfasser  from exemplar, band"
    + " where exemplar.band_id = band.band_id and exemplar.exemplar_id =" 
    + tfExemplar.getText() + ";");
    
  } // end of btBuchZeigen_ActionPerformed
  
  public void btLeserZeigen_ActionPerformed(ActionEvent evt) {
    meinVerwalter.zeigeAbfrageMehrzeilig("Leser", "select vorname, nachname, klasse from leser"
    + " where benutzer_id ="  + tfLeser.getText() + ";");
    meinVerwalter.zeigeAbfrageMehrzeilig("ausgeliehene Bcher", "select band.titel, band.verfasser from leser, exemplar, band, ausleihe"
    + " where exemplar.band_id = band.band_id and exemplar.exemplar_id = ausleihe.exemplar_id"
    + " and ausleihe.benutzer_id = leser.benutzer_id and leser.benutzer_id ="  + tfLeser.getText() + ";");
  } // end of btLeserZeigen_ActionPerformed
  
  public void btAusleihen_ActionPerformed(ActionEvent evt) {
    String feldnamen = "( `ausleih_datum`, `ausleih_id`, `benutzer_id`, `exemplar_id`, `faellig_datum`, `rueckgabe_datum`, `status` )";
    String sRueckgabe = datumAus(heuteTag, heuteMonat, heuteJahr, 3 ) ;  // 3 Monate spaeter
    
    meinVerwalter.zeigeAbfrageMehrzeilig("ausgeliehen", "INSERT INTO ausleihe "+ feldnamen + " VALUES ( '" +
    tfDatum.getText() + "'," + (++maxAusleihId) + "," + tfLeser.getText() + "," +
    tfExemplar.getText() + "," + sRueckgabe + ", NULL, 1);");
    
  } // end of btAusleihen_ActionPerformed
  
  public String datumAus (int tag, int monat, int jahr, int offsetMonat) {
    monat = monat + offsetMonat;
    if (monat > 12) {
      jahr = jahr + monat / 12;
      monat = monat % 12;
    } // end of if
    String aus = Integer.toString(jahr) ;
    if (monat<10) {
    aus = aus + "0" + monat; }
    else {
      aus = aus + monat;
    } // end of if-else
    if (tag<10) {
    aus = aus + "0" + tag; }
    else {
      aus = aus + tag;
    } // end of if-else
    aus = aus + "000000";
    return aus;
  }
  // Ende Methoden
  
  public static void main(String[] args) {
    new AusleihAnwendung("Bcherausleihe mit SQLite");
  } // end of main
} // end of class AusleihAnwendung
