import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.event.*;

/**
  *
  * SQLite - DatabaseConnector
  * Version 1.3 vom 26.2.2018
  * vom Hau 
  */

public class TabelleAendernSpeicherntAnw extends JFrame {
  // Anfang Attribute
  private JButton btStart = new JButton();  
  private Verwalter meinVerwalter;
  private JLabel jLabel2 = new JLabel();
  private JTextField tfDatenbank = new JTextField();
  private JLabel jLabel3 = new JLabel();
  private JList liTabellen = new JList();
    private DefaultListModel liTabellenModel = new DefaultListModel();
    private JScrollPane liTabellenScrollPane = new JScrollPane(liTabellen);
  private JButton btTabAnzeigen = new JButton();
  private JButton btZurueck = new JButton();
  private String aktTabelle ="";
  private JTextArea taAnzeige = new JTextArea("");
    private JScrollPane taAnzeigeScrollPane = new JScrollPane(taAnzeige);
  // Ende Attribute  
  
  public TabelleAendernSpeicherntAnw(String title) { 
    // Frame-Initialisierung
    super(title);
    setDefaultCloseOperation(WindowConstants.EXIT_ON_CLOSE); //alle Fenster zu
    setSize(709, 573);
    setLocation(20, 10);
    setResizable(true);
    Container cp = getContentPane();
    cp.setLayout(null);
    // Anfang Komponenten
    
    btStart.setBounds(376, 8, 113, 33);
    btStart.setText("Start");
    btStart.setMargin(new Insets(2, 2, 2, 2));
    btStart.addActionListener(new ActionListener() { 
      public void actionPerformed(ActionEvent evt) { 
        btStart_ActionPerformed(evt);
      }
    });
    cp.add(btStart);
    jLabel2.setBounds(16, 8, 116, 25);
    jLabel2.setText("SQLite - Datenbank:");
    cp.add(jLabel2);
    tfDatenbank.setBounds(144, 8, 201, 25);
    tfDatenbank.setText("biblio.db");
    cp.add(tfDatenbank);
    jLabel3.setBounds(16, 64, 83, 33);
    jLabel3.setText("Tabellen:");
    cp.add(jLabel3);
   //
    liTabellen.setModel(liTabellenModel);
    liTabellenScrollPane.setBounds(144, 56, 201, 137);
    liTabellen.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
    cp.add(liTabellenScrollPane);
    btTabAnzeigen.setBounds(376, 104, 129, 33);
    btTabAnzeigen.setText("Tabelle anzeigen");
    btTabAnzeigen.setMargin(new Insets(2, 2, 2, 2));
    btTabAnzeigen.addActionListener(new ActionListener() { 
      public void actionPerformed(ActionEvent evt) { 
        btTabAnzeigen_ActionPerformed(evt);
      }
    });
    cp.add(btTabAnzeigen);
    btZurueck.setBounds(544, 152, 121, 33);
    btZurueck.setText("zurckspeichern");
    btZurueck.setMargin(new Insets(2, 2, 2, 2));
    btZurueck.addActionListener(new ActionListener() { 
      public void actionPerformed(ActionEvent evt) { 
        btZurueck_ActionPerformed(evt);
      }
    });
    cp.add(btZurueck);
    taAnzeigeScrollPane.setBounds(24, 200, 641, 497);
    cp.add(taAnzeigeScrollPane);
    // Ende Komponenten
    
    setVisible(true);
  } // end of public TabelleAendernSpeicherntAnw
  
  // Anfang Methoden
    
  public void btStart_ActionPerformed(ActionEvent evt) {
    meinVerwalter = new Verwalter( );
    String aus = meinVerwalter.oeffneDB(tfDatenbank.getText());
       
    String[] tabs = aus.split("\n");
    
    liTabellenModel.removeAllElements();
    for (int i=0; i < tabs.length ; i++ ) {
      liTabellenModel.addElement(tabs[i]);
    } // end of for
  } // end of btStart_ActionPerformed
  
  public void btTabAnzeigen_ActionPerformed(ActionEvent evt) {
    aktTabelle =  (String) liTabellen.getSelectedValue();
    meinVerwalter.zeigeAbfrage("select * from " +  aktTabelle);
    
  } // end of btTabAnzeigen_ActionPerformed

  public void btZurueck_ActionPerformed(ActionEvent evt) {
    String sqlBackup = meinVerwalter.schreibeZurueck(aktTabelle);
    taAnzeige.setText(sqlBackup);
  } // end of btZurueck_ActionPerformed

  // Ende Methoden
  
  public static void main(String[] args) {
    new TabelleAendernSpeicherntAnw("Datenbankanbindung mit SQLite");
  } // end of main
} // end of class TabelleAendernSpeicherntAnw
