/*
 * Decompiled with CFR 0.152.
 */
package datastructures;

public class Queue<ContentType> {
    private QueueNode head = null;
    private QueueNode tail = null;

    public boolean isEmpty() {
        return this.head == null;
    }

    public void enqueue(ContentType pContent) {
        if (pContent != null) {
            QueueNode newNode = new QueueNode(pContent);
            if (this.isEmpty()) {
                this.head = newNode;
                this.tail = newNode;
            } else {
                this.tail.setNext(newNode);
                this.tail = newNode;
            }
        }
    }

    public void dequeue() {
        if (!this.isEmpty()) {
            this.head = this.head.getNext();
            if (this.isEmpty()) {
                this.head = null;
                this.tail = null;
            }
        }
    }

    public ContentType front() {
        if (this.isEmpty()) {
            return null;
        }
        return this.head.getContent();
    }

    private class QueueNode {
        private ContentType content = null;
        private QueueNode nextNode = null;

        public QueueNode(ContentType pContent) {
            this.content = pContent;
            this.nextNode = null;
        }

        public void setNext(QueueNode pNext) {
            this.nextNode = pNext;
        }

        public QueueNode getNext() {
            return this.nextNode;
        }

        public ContentType getContent() {
            return this.content;
        }
    }
}

