/*
 * Decompiled with CFR 0.152.
 */
package datastructures;

public class List<ContentType> {
    ListNode first = null;
    ListNode last = null;
    ListNode current = null;

    public boolean isEmpty() {
        return this.first == null;
    }

    public boolean hasAccess() {
        return this.current != null;
    }

    public void next() {
        if (this.hasAccess()) {
            this.current = this.current.getNextNode();
        }
    }

    public void toFirst() {
        if (!this.isEmpty()) {
            this.current = this.first;
        }
    }

    public void toLast() {
        if (!this.isEmpty()) {
            this.current = this.last;
        }
    }

    public ContentType getContent() {
        if (this.hasAccess()) {
            return this.current.getContentObject();
        }
        return null;
    }

    public void setContent(ContentType pContent) {
        if (pContent != null && this.hasAccess()) {
            this.current.setContentObject(pContent);
        }
    }

    public void insert(ContentType pContent) {
        if (pContent != null) {
            if (this.hasAccess()) {
                ListNode newNode = new ListNode(pContent);
                if (this.current != this.first) {
                    ListNode previous = this.getPrevious(this.current);
                    newNode.setNextNode(previous.getNextNode());
                    previous.setNextNode(newNode);
                } else {
                    newNode.setNextNode(this.first);
                    this.first = newNode;
                }
            } else if (this.isEmpty()) {
                ListNode newNode;
                this.first = newNode = new ListNode(pContent);
                this.last = newNode;
            }
        }
    }

    public void append(ContentType pContent) {
        if (pContent != null) {
            if (this.isEmpty()) {
                this.insert(pContent);
            } else {
                ListNode newNode = new ListNode(pContent);
                this.last.setNextNode(newNode);
                this.last = newNode;
            }
        }
    }

    public void concat(List<ContentType> pList) {
        if (pList != this && pList != null && !pList.isEmpty()) {
            if (this.isEmpty()) {
                this.first = pList.first;
                this.last = pList.last;
            } else {
                this.last.setNextNode(pList.first);
                this.last = pList.last;
            }
            pList.first = null;
            pList.last = null;
            pList.current = null;
        }
    }

    public void remove() {
        if (this.hasAccess() && !this.isEmpty()) {
            if (this.current == this.first) {
                this.first = this.first.getNextNode();
            } else {
                ListNode previous = this.getPrevious(this.current);
                if (this.current == this.last) {
                    this.last = previous;
                }
                previous.setNextNode(this.current.getNextNode());
            }
            ListNode temp = this.current.getNextNode();
            this.current.setContentObject(null);
            this.current.setNextNode(null);
            this.current = temp;
            if (this.isEmpty()) {
                this.last = null;
            }
        }
    }

    private ListNode getPrevious(ListNode pNode) {
        if (pNode != null && pNode != this.first && !this.isEmpty()) {
            ListNode temp;
            for (temp = this.first; temp != null && temp.getNextNode() != pNode; temp = temp.getNextNode()) {
            }
            return temp;
        }
        return null;
    }

    private class ListNode {
        private ContentType contentObject;
        private ListNode next;

        private ListNode(ContentType pContent) {
            this.contentObject = pContent;
            this.next = null;
        }

        public ContentType getContentObject() {
            return this.contentObject;
        }

        public void setContentObject(ContentType pContent) {
            this.contentObject = pContent;
        }

        public ListNode getNextNode() {
            return this.next;
        }

        public void setNextNode(ListNode pNext) {
            this.next = pNext;
        }
    }
}

