/*
 * Decompiled with CFR 0.152.
 */
package datastructures;

public class BinaryTree<ContentType> {
    private BTNode<ContentType> node;

    public BinaryTree() {
        this.node = null;
    }

    public BinaryTree(ContentType pContent) {
        this.node = pContent != null ? new BTNode<ContentType>(pContent) : null;
    }

    public BinaryTree(ContentType pContent, BinaryTree<ContentType> pLeftTree, BinaryTree<ContentType> pRightTree) {
        if (pContent != null) {
            this.node = new BTNode<ContentType>(pContent);
            if (pLeftTree != null) {
                ((BTNode)this.node).left = pLeftTree;
            } else {
                ((BTNode)this.node).left = new BinaryTree<ContentType>();
            }
            if (pRightTree != null) {
                ((BTNode)this.node).right = pRightTree;
            } else {
                ((BTNode)this.node).right = new BinaryTree<ContentType>();
            }
        } else {
            this.node = null;
        }
    }

    public boolean isEmpty() {
        return this.node == null;
    }

    public void setContent(ContentType pContent) {
        if (pContent != null) {
            if (this.isEmpty()) {
                this.node = new BTNode<ContentType>(pContent);
                ((BTNode)this.node).left = new BinaryTree<ContentType>();
                ((BTNode)this.node).right = new BinaryTree<ContentType>();
            }
            ((BTNode)this.node).content = pContent;
        }
    }

    public ContentType getContent() {
        if (this.isEmpty()) {
            return null;
        }
        return (ContentType)((BTNode)this.node).content;
    }

    public void setLeftTree(BinaryTree<ContentType> pTree) {
        if (!this.isEmpty() && pTree != null) {
            ((BTNode)this.node).left = pTree;
        }
    }

    public void setRightTree(BinaryTree<ContentType> pTree) {
        if (!this.isEmpty() && pTree != null) {
            ((BTNode)this.node).right = pTree;
        }
    }

    public BinaryTree<ContentType> getLeftTree() {
        if (!this.isEmpty()) {
            return ((BTNode)this.node).left;
        }
        return null;
    }

    public BinaryTree<ContentType> getRightTree() {
        if (!this.isEmpty()) {
            return ((BTNode)this.node).right;
        }
        return null;
    }

    private class BTNode<CT> {
        private CT content;
        private BinaryTree<CT> left;
        private BinaryTree<CT> right;

        public BTNode(CT pContent) {
            this.content = pContent;
            this.left = new BinaryTree();
            this.right = new BinaryTree();
        }
    }
}

